/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.item;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.info.EntityListCustom;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.item.ItemBase;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCustomSpawnEgg
extends ItemBase {
    public GroupInfo group = LycanitesMobs.group;
    public String itemName = "customspawnegg";
    public String texturePath = "customspawn";

    public ItemCustomSpawnEgg() {
        this.func_77627_a(true);
        this.func_77637_a(LycanitesMobs.creaturesTab);
        this.func_77655_b("customspawnegg");
    }

    public String func_77653_i(ItemStack itemStack) {
        String s = ("" + I18n.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String s1 = ItemCustomSpawnEgg.getEntityIdFromItem(itemStack);
        if (s1 != null) {
            s = s + " " + I18n.func_74838_a((String)("entity." + s1 + ".name"));
        }
        return s;
    }

    @Override
    public String getDescription(ItemStack itemStack, EntityPlayer entityPlayer, List textList, boolean par4) {
        String entityID = ItemCustomSpawnEgg.getEntityIdFromItem(itemStack);
        Class entityClass = ObjectManager.entityLists.get(this.group.filename).getClassFromID(entityID);
        MobInfo mobInfo = MobInfo.mobClassToInfo.get(entityClass);
        if (mobInfo == null) {
            LycanitesMobs.printWarning("Mob Spawn Egg", "Unable to get a MobInfo entry for id: " + entityID + " class: " + entityClass);
            return "Unable to get a MobInfo entry for id: " + entityID + " class: " + entityClass;
        }
        return mobInfo.getDescription();
    }

    @Override
    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemStack)) {
            return EnumActionResult.FAIL;
        }
        if (block == Blocks.field_150474_ac) {
            TileEntity tileEntity = world.func_175625_s(pos);
            MobSpawnerBaseLogic mobspawnerbaselogic = ((TileEntityMobSpawner)tileEntity).func_145881_a();
            mobspawnerbaselogic.func_98272_a(ItemCustomSpawnEgg.getEntityIdFromItem(itemStack));
            tileEntity.func_70296_d();
            world.func_184138_a(pos, blockState, blockState, 3);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        if (!world.field_72995_K) {
            Entity entity;
            pos = pos.func_177972_a(facing);
            double d0 = 0.0;
            if (facing == EnumFacing.UP && blockState.func_177230_c() instanceof BlockFence) {
                d0 = 0.5;
            }
            if ((entity = this.spawnCreature(world, ItemCustomSpawnEgg.getEntityIdFromItem(itemStack), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
                if (entity instanceof EntityLivingBase && itemStack.func_82837_s()) {
                    ((EntityLiving)entity).func_96094_a(itemStack.func_82833_r());
                }
                ItemCustomSpawnEgg.applyItemEntityDataToEntity(world, player, itemStack, entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemStack.field_77994_a;
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
        if (rayTraceResult == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
        }
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rayTraceResult.func_178782_a();
            if (!world.canMineBlockBody(player, pos)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
            }
            if (!player.func_175151_a(pos, rayTraceResult.field_178784_b, itemStack)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
            }
            if (world.func_180495_p(pos).func_185904_a() == Material.field_151586_h) {
                Entity entity = this.spawnCreature(world, ItemCustomSpawnEgg.getEntityIdFromItem(itemStack), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (entity != null && entity instanceof EntityLivingBase && itemStack.func_82837_s()) {
                    ((EntityLiving)entity).func_96094_a(itemStack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemStack.field_77994_a;
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public Entity spawnCreature(World world, String entityID, double x, double y, double z) {
        if (!ObjectManager.entityLists.get((Object)this.group.filename).entityEggs.containsKey(entityID)) {
            return null;
        }
        Entity entity = null;
        for (int j = 0; j < 1; ++j) {
            entity = ObjectManager.entityLists.get(this.group.filename).createEntityByID(entityID, world);
            if (entity == null || !(entity instanceof EntityLivingBase)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            entityliving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityliving)), (IEntityLivingData)null);
            world.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    @Override
    public boolean useItemColors() {
        return true;
    }

    @Override
    public int getColorFromItemstack(ItemStack itemStack, int tintIndex) {
        EntityListCustom.EntityEggInfo entityEggInfo = ObjectManager.entityLists.get((Object)this.group.filename).entityEggs.get(ItemCustomSpawnEgg.getEntityIdFromItem(itemStack));
        return entityEggInfo != null ? (tintIndex == 0 ? entityEggInfo.primaryColor : entityEggInfo.secondaryColor) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List subItems) {
        if (this.group == null || !ObjectManager.entityLists.containsKey(this.group.filename)) {
            return;
        }
        for (EntityListCustom.EntityEggInfo entityEggInfo : ObjectManager.entityLists.get((Object)this.group.filename).entityEggs.values()) {
            ItemStack itemstack = new ItemStack(item, 1);
            ItemCustomSpawnEgg.applyEntityIdToItemStack(itemstack, entityEggInfo.spawnedID);
            subItems.add(itemstack);
        }
    }

    public static void applyEntityIdToItemStack(ItemStack stack, String entityId) {
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", entityId);
        nbttagcompound.func_74782_a("EntityTag", (NBTBase)nbttagcompound1);
        stack.func_77982_d(nbttagcompound);
    }

    public static String getEntityIdFromItem(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null || !nbttagcompound.func_150297_b("EntityTag", 10)) {
            return null;
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("EntityTag");
        return !nbttagcompound1.func_150297_b("id", 8) ? null : nbttagcompound1.func_74779_i("id");
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("EntityTag", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            targetEntity.func_189511_e(nbttagcompound1);
            UUID uuid = targetEntity.func_110124_au();
            nbttagcompound1.func_179237_a(nbttagcompound.func_74775_l("EntityTag"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(nbttagcompound1);
        }
    }
}

